/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.ssl.Java14KeyManagerWrapper;
import org.apache.commons.ssl.Java14TrustManagerWrapper;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.TrustChain;
import org.apache.commons.ssl.Util;

public final class Java14
extends JavaImpl {
    private static Java14 instance = new Java14();

    private Java14() {
        try {
            SSLSocketFactory.getDefault().createSocket();
        }
        catch (IOException ioe) {
            ioe.hashCode();
        }
    }

    public static Java14 getInstance() {
        return instance;
    }

    @Override
    public final String getVersion() {
        return "Java14";
    }

    @Override
    protected final String retrieveSubjectX500(X509Certificate cert) {
        return cert.getSubjectX500Principal().toString();
    }

    @Override
    protected final String retrieveIssuerX500(X509Certificate cert) {
        return cert.getIssuerX500Principal().toString();
    }

    @Override
    protected final Certificate[] retrievePeerCerts(SSLSession sslSession) throws SSLPeerUnverifiedException {
        return sslSession.getPeerCertificates();
    }

    @Override
    protected final Object buildKeyManagerFactory(KeyStore ks, char[] password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(alg);
        kmf.init(ks, password);
        return kmf;
    }

    @Override
    protected final Object buildTrustManagerFactory(KeyStore ks) throws NoSuchAlgorithmException, KeyStoreException {
        String alg = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(alg);
        tmf.init(ks);
        return tmf;
    }

    @Override
    protected final Object[] retrieveKeyManagers(Object keyManagerFactory) {
        KeyManagerFactory kmf = (KeyManagerFactory)keyManagerFactory;
        return kmf.getKeyManagers();
    }

    @Override
    protected final Object[] retrieveTrustManagers(Object trustManagerFactory) {
        TrustManagerFactory tmf = (TrustManagerFactory)trustManagerFactory;
        return tmf.getTrustManagers();
    }

    @Override
    protected final SSLSocketFactory buildSSLSocketFactory(Object ssl) {
        return ((SSLContext)ssl).getSocketFactory();
    }

    @Override
    protected final SSLServerSocketFactory buildSSLServerSocketFactory(Object ssl) {
        return ((SSLContext)ssl).getServerSocketFactory();
    }

    @Override
    protected final RuntimeException buildRuntimeException(Exception cause) {
        return new RuntimeException(cause);
    }

    @Override
    protected final SSLSocket buildSocket(SSL ssl) throws IOException {
        SSLSocketFactory sf = ssl.getSSLSocketFactory();
        SSLSocket s = (SSLSocket)sf.createSocket();
        ssl.doPreConnectSocketStuff(s);
        return s;
    }

    @Override
    protected final SSLSocket buildSocket(SSL ssl, String remoteHost, int remotePort, InetAddress localHost, int localPort, int timeout) throws IOException {
        SSLSocket s = this.buildSocket(ssl);
        s = (SSLSocket)this.connectSocket(s, null, remoteHost, remotePort, localHost, localPort, timeout, ssl);
        ssl.doPostConnectSocketStuff(s, remoteHost);
        return s;
    }

    @Override
    protected final Socket buildPlainSocket(SSL ssl, String remoteHost, int remotePort, InetAddress localHost, int localPort, int timeout) throws IOException {
        Socket s = SocketFactory.getDefault().createSocket();
        ssl.doPreConnectSocketStuff(s);
        s = this.connectSocket(s, null, remoteHost, remotePort, localHost, localPort, timeout, ssl);
        ssl.doPostConnectSocketStuff(s, remoteHost);
        return s;
    }

    @Override
    protected final Socket connectSocket(Socket s, SocketFactory sf, String host, int remotePort, InetAddress localHost, int localPort, int timeout, SSL ssl) throws IOException {
        if (s == null) {
            s = sf == null ? new Socket() : sf.createSocket();
        }
        host = ssl.dnsOverride(host);
        InetAddress remoteHost = Util.toInetAddress(host);
        InetSocketAddress dest = new InetSocketAddress(remoteHost, remotePort);
        InetSocketAddress src = new InetSocketAddress(localHost, localPort);
        if (s instanceof SSLSocket) {
            Java14.setHostForSNI((SSLSocket)s, host);
        }
        s.bind(src);
        s.connect(dest, timeout);
        return s;
    }

    private static boolean returnsVoidTakesOneString(Method m) {
        Class<?>[] params = m.getParameterTypes();
        return Void.TYPE.equals(m.getReturnType()) && params != null && params.length == 1 && String.class.equals(params[0]);
    }

    public static void setHostForSNI(SSLSocket s, String host) throws IOException {
        Method[] methods = s.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!Java14.returnsVoidTakesOneString(m) || !"setHost".equals(m.getName())) continue;
            try {
                m.invoke((Object)s, host);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new IOException("setHost() via reflection failed: " + t);
            }
        }
    }

    @Override
    protected final SSLServerSocket buildServerSocket(SSL ssl) throws IOException {
        ServerSocket s = ssl.getSSLServerSocketFactory().createServerSocket();
        SSLServerSocket ss = (SSLServerSocket)s;
        ssl.doPreConnectServerSocketStuff(ss);
        return ss;
    }

    @Override
    protected final void wantClientAuth(Object o, boolean wantClientAuth) {
        if (o instanceof SSLSocket) {
            SSLSocket s = (SSLSocket)o;
            s.setWantClientAuth(wantClientAuth);
        } else if (o instanceof SSLServerSocket) {
            SSLServerSocket ss = (SSLServerSocket)o;
            ss.setWantClientAuth(wantClientAuth);
        } else {
            throw new ClassCastException("need SSLSocket or SSLServerSocket");
        }
    }

    @Override
    protected final void enabledProtocols(Object o, String[] enabledProtocols) {
        if (o instanceof SSLSocket) {
            SSLSocket s = (SSLSocket)o;
            s.setEnabledProtocols(enabledProtocols);
        } else if (o instanceof SSLServerSocket) {
            SSLServerSocket ss = (SSLServerSocket)o;
            ss.setEnabledProtocols(enabledProtocols);
        } else {
            throw new ClassCastException("need SSLSocket or SSLServerSocket");
        }
    }

    @Override
    protected void checkTrusted(Object trustManager, X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = (X509TrustManager)trustManager;
        tm.checkServerTrusted(chain, authType);
    }

    @Override
    protected final Object initSSL(SSL ssl, TrustChain tc, KeyMaterial k) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, KeyManagementException, IOException {
        int i;
        SSLContext context = SSLContext.getInstance(ssl.getDefaultProtocol());
        TrustManager[] trustManagers = null;
        KeyManager[] keyManagers = null;
        if (tc != null) {
            trustManagers = (TrustManager[])tc.getTrustManagers();
        }
        if (k != null) {
            keyManagers = (KeyManager[])k.getKeyManagers();
        }
        if (keyManagers != null) {
            for (i = 0; i < keyManagers.length; ++i) {
                if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                X509KeyManager km = (X509KeyManager)keyManagers[i];
                keyManagers[i] = new Java14KeyManagerWrapper(km, k, ssl);
            }
        }
        if (trustManagers != null) {
            for (i = 0; i < trustManagers.length; ++i) {
                if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                X509TrustManager tm = (X509TrustManager)trustManagers[i];
                trustManagers[i] = new Java14TrustManagerWrapper(tm, tc, ssl);
            }
        }
        context.init(keyManagers, trustManagers, null);
        return context;
    }
}

