/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import purejavahidapi.DeviceRemovalListener;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.InputReportListener;
import purejavahidapi.PureJavaHidApi;

public class Example2 {
    static volatile boolean deviceOpen = false;

    public static void main(String[] args) {
        try {
            while (true) {
                HidDeviceInfo devInfo = null;
                if (deviceOpen) continue;
                System.out.println("scanning");
                List<HidDeviceInfo> devList = PureJavaHidApi.enumerateDevices();
                for (HidDeviceInfo info : devList) {
                    if (info.getVendorId() != 5840 || info.getProductId() != 1099) continue;
                    devInfo = info;
                    break;
                }
                if (devInfo == null) {
                    System.out.println("device not found");
                    Thread.sleep(1000L);
                    continue;
                }
                System.out.println("device found");
                deviceOpen = true;
                final HidDevice dev = PureJavaHidApi.openDevice(devInfo);
                dev.setDeviceRemovalListener(new DeviceRemovalListener(){

                    @Override
                    public void onDeviceRemoval(HidDevice source) {
                        System.out.println("device removed");
                        deviceOpen = false;
                    }
                });
                dev.setInputReportListener(new InputReportListener(){

                    @Override
                    public void onInputReport(HidDevice source, byte Id, byte[] data, int len) {
                        System.out.printf("onInputReport: id %d len %d data ", Id, len);
                        for (int i = 0; i < len; ++i) {
                            System.out.printf("%02X ", data[i]);
                        }
                        System.out.println();
                    }
                });
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            byte[] data = new byte[132];
                            data[0] = 1;
                            int len = 0;
                            len = dev.getFeatureReport(data, data.length);
                            if (len < 0) continue;
                            byte Id = data[0];
                            System.out.printf("getFeatureReport: id %d len %d data ", Id, len);
                            for (int i = 0; i < data.length; ++i) {
                                System.out.printf("%02X ", data[i]);
                            }
                            System.out.println();
                        }
                    }
                }).start();
                Thread.sleep(2000L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }
}

