/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.pe;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SectionFlag {
    TYPE_NO_PAD(8),
    CODE(32),
    INITIALIZED_DATA(64),
    UNINITIALIZED_DATA(128),
    LNK_OTHER(256),
    LNK_INFO(512),
    LNK_REMOVE(2048),
    LNK_COMDAT(4096),
    GPREL(32768),
    MEM_PURGEABLE(131072),
    MEM_16BIT(131072),
    MEM_LOCKED(262144),
    MEM_PRELOAD(524288),
    ALIGN_1BYTES(0x100000),
    ALIGN_2BYTES(0x200000),
    ALIGN_4BYTES(0x300000),
    ALIGN_8BYTES(0x400000),
    ALIGN_16BYTES(0x500000),
    ALIGN_32BYTES(0x600000),
    ALIGN_64BYTES(0x700000),
    ALIGN_128BYTES(0x800000),
    ALIGN_256BYTES(0x900000),
    ALIGN_512BYTES(0xA00000),
    ALIGN_1024BYTES(0xB00000),
    ALIGN_2048BYTES(0xC00000),
    ALIGN_4096BYTES(0xD00000),
    ALIGN_8192BYTES(0xE00000),
    LNK_NRELOC_OVFL(0x1000000),
    MEM_DISCARDABLE(0x2000000),
    MEM_NOT_CACHED(0x4000000),
    MEM_NOT_PAGED(0x8000000),
    MEM_SHARED(0x10000000),
    EXECUTE(0x20000000),
    READ(0x40000000),
    WRITE(Integer.MIN_VALUE);

    private final int mask;

    private SectionFlag(int mask) {
        this.mask = mask;
    }

    static List<SectionFlag> getFlags(int flags) {
        ArrayList<SectionFlag> result = new ArrayList<SectionFlag>();
        for (SectionFlag flag : SectionFlag.values()) {
            if ((flag.mask & flags) == 0) continue;
            result.add(flag);
        }
        return result;
    }
}

