/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.asn1.authenticode;

import java.io.IOException;
import java.io.OutputStream;
import net.jsign.asn1.authenticode.AuthenticodeSignedData;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;

public class AuthenticodeSignedDataGenerator
extends CMSSignedDataGenerator {
    public CMSSignedData generate(ASN1ObjectIdentifier contentTypeOID, ASN1Encodable content) throws CMSException, IOException {
        SignerInfo signerInfo;
        this.digests.clear();
        if (!this._signers.isEmpty()) {
            signerInfo = ((SignerInformation)this._signers.get(0)).toASN1Structure();
        } else {
            SignerInfoGenerator signerInfoGenerator = (SignerInfoGenerator)this.signerGens.get(0);
            try {
                byte[] signedContent = content.toASN1Primitive().getEncoded("DER");
                OutputStream out = signerInfoGenerator.getCalculatingOutputStream();
                out.write(signedContent, 2, signedContent.length - 2);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                throw new CMSException("data processing exception: " + e.getMessage(), e);
            }
            signerInfo = signerInfoGenerator.generate(contentTypeOID);
            byte[] calculatedDigest = signerInfoGenerator.getCalculatedDigest();
            this.digests.put(signerInfoGenerator.getDigestAlgorithm().getAlgorithm().getId(), calculatedDigest);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, content);
        DERSet certificates = new DERSet(this.certs.toArray(new ASN1Encodable[0]));
        AuthenticodeSignedData signedData = new AuthenticodeSignedData(signerInfo.getDigestAlgorithm(), encInfo, certificates, signerInfo);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, signedData);
        return new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(contentTypeOID, content.toASN1Primitive().getEncoded("DER")), contentInfo);
    }
}

