/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.windows;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.shared.SyncPoint;
import purejavahidapi.windows.HidLibrary;
import purejavahidapi.windows.Kernel32Library;
import purejavahidapi.windows.WinDef;
import purejavahidapi.windows.WindowsBackend;

public class HidDevice
extends purejavahidapi.HidDevice {
    private WindowsBackend m_Backend;
    private WinDef.HANDLE m_Handle;
    private int m_OutputReportLength;
    private Memory m_OutputReportMemory;
    private WinDef.OVERLAPPED m_OutputReportOverlapped;
    private int[] m_OutputReportBytesWritten;
    private int m_InputReportLength;
    private WinDef.OVERLAPPED m_InputReportOverlapped = new WinDef.OVERLAPPED();
    private Memory m_InputReportMemory;
    private byte[] m_InputReportBytes;
    private int[] m_InputReportBytesRead = new int[]{0};
    private Thread m_Thread;
    private SyncPoint m_SyncStart;
    private SyncPoint m_SyncShutdown;
    private boolean m_StopThread;
    private boolean m_ForceControlOutput;

    HidDevice(HidDeviceInfo deviceInfo, WindowsBackend backend) {
        WinDef.HANDLE handle = WindowsBackend.openDeviceHandle(deviceInfo.getPath(), false);
        if (handle == WinDef.INVALID_HANDLE_VALUE) {
            return;
        }
        this.m_Backend = backend;
        this.m_Handle = handle;
        HidLibrary.HIDD_ATTRIBUTES attrib = new HidLibrary.HIDD_ATTRIBUTES();
        attrib.Size = new NativeLong((long)attrib.size());
        HidLibrary.HidD_GetAttributes(handle, attrib);
        this.m_HidDeviceInfo = (purejavahidapi.windows.HidDeviceInfo)deviceInfo;
        HidLibrary.HIDP_PREPARSED_DATA[] ppd = new HidLibrary.HIDP_PREPARSED_DATA[1];
        boolean res = HidLibrary.HidD_GetPreparsedData(handle, ppd);
        if (!res) {
            Kernel32Library.CloseHandle(handle);
            return;
        }
        HidLibrary.HIDP_CAPS caps = new HidLibrary.HIDP_CAPS();
        int nt_res = HidLibrary.HidP_GetCaps(ppd[0], caps);
        if (nt_res != 0x110000) {
            Kernel32Library.CloseHandle(handle);
            return;
        }
        this.m_OutputReportLength = caps.OutputReportByteLength;
        if (this.m_OutputReportLength > 0) {
            this.m_OutputReportMemory = new Memory((long)this.m_OutputReportLength);
        }
        this.m_OutputReportOverlapped = new WinDef.OVERLAPPED();
        this.m_OutputReportBytesWritten = new int[]{0};
        this.m_InputReportLength = caps.InputReportByteLength;
        this.m_InputReportOverlapped = new WinDef.OVERLAPPED();
        if (this.m_InputReportLength > 0) {
            this.m_InputReportMemory = new Memory((long)this.m_InputReportLength);
            this.m_InputReportBytes = new byte[this.m_InputReportLength];
        }
        this.m_InputReportBytesRead = new int[]{0};
        HidLibrary.HidD_FreePreparsedData(ppd[0]);
        this.m_SyncStart = new SyncPoint(2);
        this.m_SyncShutdown = new SyncPoint(2);
        this.m_Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HidDevice.this.runReadOnBackground();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, this.m_HidDeviceInfo.getPath());
        this.m_Backend.addDevice(this.m_HidDeviceInfo.getDeviceId(), this);
        this.m_Open = true;
        if (this.m_InputReportLength > 0) {
            this.m_Thread.start();
            this.m_SyncStart.waitAndSync();
        }
        this.m_ForceControlOutput = System.getProperty("purejavahidapi.forceControlOutput") != null;
    }

    @Override
    public synchronized void close() {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_StopThread = true;
        if (this.m_InputReportLength > 0) {
            Kernel32Library.CancelIoEx(this.m_Handle, null);
            this.m_Thread.interrupt();
            this.m_SyncShutdown.waitAndSync();
        }
        Kernel32Library.CloseHandle(this.m_Handle);
        this.m_Backend.removeDevice(this.m_HidDeviceInfo.getDeviceId());
        this.m_Open = false;
    }

    @Override
    public synchronized int setOutputReport(byte reportID, byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        if (this.m_OutputReportLength == 0) {
            throw new IllegalArgumentException("this device supportst no output reports");
        }
        this.m_OutputReportMemory.write(0L, new byte[]{reportID}, 0, 1);
        this.m_OutputReportMemory.write(1L, data, 0, length);
        if (!this.m_ForceControlOutput) {
            if (!Kernel32Library.WriteFile(this.m_Handle, (Pointer)this.m_OutputReportMemory, this.m_OutputReportLength, null, this.m_OutputReportOverlapped) && Kernel32Library.GetLastError() != 997) {
                return -1;
            }
            if (!Kernel32Library.GetOverlappedResult(this.m_Handle, this.m_OutputReportOverlapped, this.m_OutputReportBytesWritten, true)) {
                return 0;
            }
            return this.m_OutputReportBytesWritten[0] - 1;
        }
        if (!HidLibrary.HidD_SetOutputReport(this.m_Handle, this.m_OutputReportMemory.getByteArray(0L, length + 1), length + 1)) {
            return -1;
        }
        return length;
    }

    @Override
    public synchronized int setFeatureReport(byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        if (!HidLibrary.HidD_SetFeature(this.m_Handle, data, length)) {
            return -1;
        }
        return length;
    }

    @Override
    public synchronized int getFeatureReport(byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        Memory buffer = new Memory((long)data.length);
        int[] bytes = new int[]{0};
        WinDef.OVERLAPPED ol = new WinDef.OVERLAPPED();
        if (!Kernel32Library.DeviceIoControl(this.m_Handle, 721298, (Pointer)buffer, length, (Pointer)buffer, length, bytes, ol) && Kernel32Library.GetLastError() != 997) {
            return -1;
        }
        if (!Kernel32Library.GetOverlappedResult(this.m_Handle, ol, bytes, true)) {
            return -1;
        }
        int n = bytes[0];
        byte[] t = buffer.getByteArray(0L, n);
        System.arraycopy(t, 0, data, 0, n);
        return n;
    }

    private void runReadOnBackground() {
        this.m_SyncStart.waitAndSync();
        while (!this.m_StopThread) {
            this.m_InputReportBytesRead[0] = 0;
            Kernel32Library.ResetEvent(this.m_InputReportOverlapped.hEvent);
            if (!Kernel32Library.ReadFile(this.m_Handle, (Pointer)this.m_InputReportMemory, this.m_InputReportLength, null, this.m_InputReportOverlapped)) {
                if (Kernel32Library.GetLastError() == 1167) break;
                if (Kernel32Library.GetLastError() != 997) {
                    Kernel32Library.CancelIo(this.m_Handle);
                    System.out.println("ReadFile failed with GetLastError()==" + Kernel32Library.GetLastError());
                }
            }
            if (!Kernel32Library.GetOverlappedResult(this.m_Handle, this.m_InputReportOverlapped, this.m_InputReportBytesRead, true)) {
                if (Kernel32Library.GetLastError() == 1167) break;
                System.out.println("GetOverlappedResult failed with GetLastError()==" + Kernel32Library.GetLastError());
            }
            if (this.m_InputReportBytesRead[0] <= 0) continue;
            byte reportID = this.m_InputReportMemory.getByte(0L);
            this.m_InputReportBytesRead[0] = this.m_InputReportBytesRead[0] - 1;
            this.m_InputReportMemory.read(1L, this.m_InputReportBytes, 0, this.m_InputReportBytesRead[0]);
            if (this.m_InputReportListener == null) continue;
            this.m_InputReportListener.onInputReport(this, reportID, this.m_InputReportBytes, this.m_InputReportBytesRead[0]);
        }
        this.m_SyncShutdown.waitAndSync();
    }
}

