/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.hidparser;

import purejavahidapi.hidparser.Collection;
import purejavahidapi.hidparser.HidParser;
import purejavahidapi.hidparser.Report;

public final class Field {
    Report m_Report;
    Collection m_Collection;
    int m_Physical;
    int m_Logical;
    int m_Application;
    int m_Usage;
    int m_Flags;
    int m_ReportOffset;
    int m_ReportSize;
    int m_ReportType;
    int m_LogicalMinimum;
    int m_LogicalMaximum;
    int m_PhysicalMinimum;
    int m_PhysicalMaximum;
    int m_UnitExponent;
    int m_Unit;

    Field(Collection collection) {
        this.m_Collection = collection;
        this.m_Collection.add(this);
    }

    public void dump(String tab) {
        HidParser.printf(tab + "-FIELD-------------------------\n", new Object[0]);
        HidParser.printf(tab + "        usage: 0x%04X:0x%04X\n", 0xFFFF & this.m_Usage >> 16 & 0xFFFF, this.m_Usage & 0xFFFF);
        HidParser.printf(tab + "        flags: 0x%08X\n", this.m_Flags);
        HidParser.printf(tab + "    report id: 0x%02X\n", this.m_Report.m_Id);
        HidParser.printf(tab + "         type: %s\n", (new String[]{"input", "output", "feature"})[this.m_Report.m_Type]);
        HidParser.printf(tab + "       offset: %d\n", this.m_ReportOffset);
        HidParser.printf(tab + "         size: %d\n", this.m_ReportSize);
        HidParser.printf(tab + "  logical min: %d\n", this.m_LogicalMinimum);
        HidParser.printf(tab + "  logical max: %d\n", this.m_LogicalMaximum);
        HidParser.printf(tab + " physical min: %d\n", this.m_PhysicalMinimum);
        HidParser.printf(tab + " physical max: %d\n", this.m_PhysicalMaximum);
        HidParser.printf(tab + "         unit: %d\n", this.m_Unit);
        HidParser.printf(tab + "     unit exp: %d\n", this.m_UnitExponent);
    }
}

