/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.CharsetMBCS;
import com.ibm.icu.charset.UConverterSharedData;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetLMBCS
extends CharsetICU {
    private static final short ULMBCS_CHARSIZE_MAX = 3;
    private static final short ULMBCS_C0END = 31;
    private static final short ULMBCS_C1START = 128;
    private static final short ULMBCS_GRP_L1 = 1;
    private static final short ULMBCS_GRP_GR = 2;
    private static final short ULMBCS_GRP_HE = 3;
    private static final short ULMBCS_GRP_AR = 4;
    private static final short ULMBCS_GRP_RU = 5;
    private static final short ULMBCS_GRP_L2 = 6;
    private static final short ULMBCS_GRP_TR = 8;
    private static final short ULMBCS_GRP_TH = 11;
    private static final short ULMBCS_GRP_JA = 16;
    private static final short ULMBCS_GRP_KO = 17;
    private static final short ULMBCS_GRP_TW = 18;
    private static final short ULMBCS_GRP_CN = 19;
    private static final short ULMBCS_DOUBLEOPTGROUP_START = 16;
    private static final short ULMBCS_HT = 9;
    private static final short ULMBCS_LF = 10;
    private static final short ULMBCS_CR = 13;
    private static final short ULMBCS_123SYSTEMRANGE = 25;
    private static final short ULMBCS_GRP_CTRL = 15;
    private static final short ULMBCS_CTRLOFFSET = 32;
    private static final short ULMBCS_GRP_EXCEPT = 0;
    private static final short ULMBCS_GRP_UNICODE = 20;
    private static char ULMBCS_UNICOMPATZERO = (char)246;
    private static final short ULMBCS_UNICODE_SIZE = 3;
    private static final short ULMBCS_GRP_LAST = 19;
    private static final String[] OptGroupByteToCPName = new String[]{"lmb-excp", "ibm-850", "ibm-851", "windows-1255", "windows-1256", "windows-1251", "ibm-852", null, "windows-1254", null, null, "windows-874", null, null, null, null, "windows-932", "windows-949", "windows-950", "windows-936", null};
    private static final short ULMBCS_AMBIGUOUS_SBCS = 128;
    private static final short ULMBCS_AMBIGUOUS_MBCS = 129;
    private static final short ULMBCS_AMBIGUOUS_ALL = 130;
    private static final _UniLMBCSGrpMap[] UniLMBCSGrpMap = new _UniLMBCSGrpMap[]{new _UniLMBCSGrpMap(1, 31, 15), new _UniLMBCSGrpMap(128, 159, 15), new _UniLMBCSGrpMap(160, 166, 128), new _UniLMBCSGrpMap(167, 168, 130), new _UniLMBCSGrpMap(169, 175, 128), new _UniLMBCSGrpMap(176, 177, 130), new _UniLMBCSGrpMap(178, 179, 128), new _UniLMBCSGrpMap(180, 180, 130), new _UniLMBCSGrpMap(181, 181, 128), new _UniLMBCSGrpMap(182, 182, 130), new _UniLMBCSGrpMap(183, 214, 128), new _UniLMBCSGrpMap(215, 215, 130), new _UniLMBCSGrpMap(216, 246, 128), new _UniLMBCSGrpMap(247, 247, 130), new _UniLMBCSGrpMap(248, 461, 128), new _UniLMBCSGrpMap(462, 462, 18), new _UniLMBCSGrpMap(463, 697, 128), new _UniLMBCSGrpMap(698, 698, 19), new _UniLMBCSGrpMap(700, 712, 128), new _UniLMBCSGrpMap(713, 720, 129), new _UniLMBCSGrpMap(728, 733, 128), new _UniLMBCSGrpMap(900, 912, 128), new _UniLMBCSGrpMap(913, 937, 130), new _UniLMBCSGrpMap(938, 944, 128), new _UniLMBCSGrpMap(945, 969, 130), new _UniLMBCSGrpMap(970, 974, 128), new _UniLMBCSGrpMap(1024, 1024, 5), new _UniLMBCSGrpMap(1025, 1025, 130), new _UniLMBCSGrpMap(1026, 1039, 5), new _UniLMBCSGrpMap(1040, 1073, 130), new _UniLMBCSGrpMap(1074, 1102, 5), new _UniLMBCSGrpMap(1103, 1103, 130), new _UniLMBCSGrpMap(1104, 1169, 5), new _UniLMBCSGrpMap(1456, 1522, 3), new _UniLMBCSGrpMap(1548, 1711, 4), new _UniLMBCSGrpMap(3585, 3675, 11), new _UniLMBCSGrpMap(8204, 8207, 128), new _UniLMBCSGrpMap(8208, 8208, 129), new _UniLMBCSGrpMap(8211, 8212, 128), new _UniLMBCSGrpMap(8213, 8213, 129), new _UniLMBCSGrpMap(8214, 8214, 129), new _UniLMBCSGrpMap(8215, 8215, 128), new _UniLMBCSGrpMap(8216, 8217, 130), new _UniLMBCSGrpMap(8218, 8219, 128), new _UniLMBCSGrpMap(8220, 8221, 130), new _UniLMBCSGrpMap(8222, 8223, 128), new _UniLMBCSGrpMap(8224, 8225, 130), new _UniLMBCSGrpMap(8226, 8228, 128), new _UniLMBCSGrpMap(8229, 8229, 129), new _UniLMBCSGrpMap(8230, 8230, 130), new _UniLMBCSGrpMap(8231, 8231, 18), new _UniLMBCSGrpMap(8240, 8240, 130), new _UniLMBCSGrpMap(8241, 8241, 128), new _UniLMBCSGrpMap(8242, 8243, 129), new _UniLMBCSGrpMap(8245, 8245, 129), new _UniLMBCSGrpMap(8249, 8250, 128), new _UniLMBCSGrpMap(8251, 8251, 129), new _UniLMBCSGrpMap(8252, 8252, 0), new _UniLMBCSGrpMap(8308, 8308, 17), new _UniLMBCSGrpMap(8319, 8319, 0), new _UniLMBCSGrpMap(8321, 8324, 17), new _UniLMBCSGrpMap(8356, 8364, 128), new _UniLMBCSGrpMap(8451, 8457, 129), new _UniLMBCSGrpMap(8465, 8480, 128), new _UniLMBCSGrpMap(8481, 8481, 129), new _UniLMBCSGrpMap(8482, 8486, 128), new _UniLMBCSGrpMap(8491, 8491, 129), new _UniLMBCSGrpMap(8501, 8501, 128), new _UniLMBCSGrpMap(8531, 8532, 17), new _UniLMBCSGrpMap(8539, 8542, 0), new _UniLMBCSGrpMap(8544, 8569, 129), new _UniLMBCSGrpMap(8592, 8595, 130), new _UniLMBCSGrpMap(8596, 8597, 0), new _UniLMBCSGrpMap(8598, 8601, 129), new _UniLMBCSGrpMap(8616, 8616, 0), new _UniLMBCSGrpMap(8632, 8633, 19), new _UniLMBCSGrpMap(8656, 8657, 0), new _UniLMBCSGrpMap(8658, 8658, 129), new _UniLMBCSGrpMap(8659, 8659, 0), new _UniLMBCSGrpMap(8660, 8660, 129), new _UniLMBCSGrpMap(8661, 8661, 0), new _UniLMBCSGrpMap(8679, 8679, 19), new _UniLMBCSGrpMap(8704, 8704, 129), new _UniLMBCSGrpMap(8705, 8705, 0), new _UniLMBCSGrpMap(8706, 8706, 129), new _UniLMBCSGrpMap(8707, 8707, 129), new _UniLMBCSGrpMap(8708, 8710, 0), new _UniLMBCSGrpMap(8711, 8712, 129), new _UniLMBCSGrpMap(8713, 8714, 0), new _UniLMBCSGrpMap(8715, 8715, 129), new _UniLMBCSGrpMap(8719, 8725, 129), new _UniLMBCSGrpMap(8729, 8729, 0), new _UniLMBCSGrpMap(8730, 8730, 129), new _UniLMBCSGrpMap(8731, 8732, 0), new _UniLMBCSGrpMap(8733, 8734, 129), new _UniLMBCSGrpMap(8735, 8735, 0), new _UniLMBCSGrpMap(8736, 8736, 129), new _UniLMBCSGrpMap(8739, 8746, 129), new _UniLMBCSGrpMap(8747, 8765, 129), new _UniLMBCSGrpMap(8773, 8776, 0), new _UniLMBCSGrpMap(8780, 8780, 18), new _UniLMBCSGrpMap(8786, 8786, 129), new _UniLMBCSGrpMap(8800, 8801, 129), new _UniLMBCSGrpMap(8802, 8805, 0), new _UniLMBCSGrpMap(8806, 8815, 129), new _UniLMBCSGrpMap(8834, 8835, 129), new _UniLMBCSGrpMap(8836, 8837, 0), new _UniLMBCSGrpMap(8838, 8839, 129), new _UniLMBCSGrpMap(8840, 8855, 0), new _UniLMBCSGrpMap(8857, 8895, 129), new _UniLMBCSGrpMap(8896, 8896, 0), new _UniLMBCSGrpMap(8976, 8976, 0), new _UniLMBCSGrpMap(8978, 8978, 129), new _UniLMBCSGrpMap(8984, 8993, 0), new _UniLMBCSGrpMap(8984, 8993, 19), new _UniLMBCSGrpMap(9312, 9449, 129), new _UniLMBCSGrpMap(9472, 9472, 128), new _UniLMBCSGrpMap(9473, 9473, 129), new _UniLMBCSGrpMap(9474, 9474, 130), new _UniLMBCSGrpMap(9475, 9475, 129), new _UniLMBCSGrpMap(9476, 9477, 18), new _UniLMBCSGrpMap(9478, 9829, 130), new _UniLMBCSGrpMap(9830, 9830, 0), new _UniLMBCSGrpMap(9831, 9833, 128), new _UniLMBCSGrpMap(9834, 9834, 130), new _UniLMBCSGrpMap(9835, 9836, 128), new _UniLMBCSGrpMap(9837, 9837, 129), new _UniLMBCSGrpMap(9838, 9838, 128), new _UniLMBCSGrpMap(9839, 9839, 16), new _UniLMBCSGrpMap(9840, 11903, 128), new _UniLMBCSGrpMap(11904, 63585, 129), new _UniLMBCSGrpMap(63586, 63743, 0), new _UniLMBCSGrpMap(63744, 64045, 129), new _UniLMBCSGrpMap(64256, 65279, 128), new _UniLMBCSGrpMap(65281, 65518, 129), new _UniLMBCSGrpMap(65535, 65535, 20)};
    private static final _LocaleLMBCSGrpMap[] LocaleLMBCSGrpMap = new _LocaleLMBCSGrpMap[]{new _LocaleLMBCSGrpMap("ar", 4), new _LocaleLMBCSGrpMap("be", 5), new _LocaleLMBCSGrpMap("bg", 6), new _LocaleLMBCSGrpMap("cs", 6), new _LocaleLMBCSGrpMap("el", 2), new _LocaleLMBCSGrpMap("he", 3), new _LocaleLMBCSGrpMap("hu", 6), new _LocaleLMBCSGrpMap("iw", 3), new _LocaleLMBCSGrpMap("ja", 16), new _LocaleLMBCSGrpMap("ko", 17), new _LocaleLMBCSGrpMap("mk", 5), new _LocaleLMBCSGrpMap("pl", 6), new _LocaleLMBCSGrpMap("ro", 6), new _LocaleLMBCSGrpMap("ru", 5), new _LocaleLMBCSGrpMap("sh", 6), new _LocaleLMBCSGrpMap("sk", 6), new _LocaleLMBCSGrpMap("sl", 6), new _LocaleLMBCSGrpMap("sq", 6), new _LocaleLMBCSGrpMap("sr", 5), new _LocaleLMBCSGrpMap("th", 11), new _LocaleLMBCSGrpMap("tr", 8), new _LocaleLMBCSGrpMap("uk", 5), new _LocaleLMBCSGrpMap("zhTW", 18), new _LocaleLMBCSGrpMap("zh", 19), new _LocaleLMBCSGrpMap(null, 1)};
    private UConverterDataLMBCS extraInfo;
    private byte[] fromUSubstitution = new byte[]{63};

    private boolean ULMBCS_AMBIGUOUS_MATCH(short agroup, short xgroup) {
        return agroup == 128 && xgroup < 16 || agroup == 129 && xgroup >= 16 || agroup == 130;
    }

    static short FindLMBCSUniRange(char uniChar) {
        int index = 0;
        while (uniChar > CharsetLMBCS.UniLMBCSGrpMap[index].uniEndRange) {
            ++index;
        }
        if (uniChar >= CharsetLMBCS.UniLMBCSGrpMap[index].uniStartRange) {
            return CharsetLMBCS.UniLMBCSGrpMap[index].GrpType;
        }
        return 20;
    }

    static short FindLMBCSLocale(String LocaleID) {
        int index = 0;
        if (LocaleID == null) {
            return 0;
        }
        while (CharsetLMBCS.LocaleLMBCSGrpMap[index].LocaleID != null) {
            if (CharsetLMBCS.LocaleLMBCSGrpMap[index].LocaleID.equals(LocaleID)) {
                return CharsetLMBCS.LocaleLMBCSGrpMap[index].OptGroup;
            }
            if (CharsetLMBCS.LocaleLMBCSGrpMap[index].LocaleID.compareTo(LocaleID) > 0) break;
            ++index;
        }
        return 1;
    }

    public CharsetLMBCS(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 3;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.extraInfo = new UConverterDataLMBCS();
        for (int i = 0; i <= 19; ++i) {
            if (OptGroupByteToCPName[i] == null) continue;
            this.extraInfo.OptGrpConverter[i] = ((CharsetMBCS)CharsetICU.forNameICU((String)CharsetLMBCS.OptGroupByteToCPName[i])).sharedData;
        }
        int option = Integer.parseInt(icuCanonicalName.substring(6));
        this.extraInfo.OptGroup = (short)option;
        this.extraInfo.localeConverterIndex = CharsetLMBCS.FindLMBCSLocale(ULocale.getDefault().getBaseName());
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderLMBCS(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderLMBCS(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        CharsetLMBCS.getCompleteUnicodeSet(setFillIn);
    }

    class CharsetEncoderLMBCS
    extends CharsetEncoderICU {
        public CharsetEncoderLMBCS(CharsetICU cs) {
            super(cs, CharsetLMBCS.this.fromUSubstitution);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
        }

        private int LMBCSConversionWorker(short group, byte[] LMBCS, char pUniChar, short[] lastConverterIndex, boolean[] groups_tried) {
            int pLMBCS = 0;
            UConverterSharedData xcnv = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[group];
            int[] value = new int[1];
            ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.charset.sharedData = xcnv;
            int bytesConverted = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.encoder.fromUChar32(pUniChar, value, false);
            if (bytesConverted <= 0) {
                groups_tried[group] = true;
                return 0;
            }
            short firstByte = (short)(value[0] >> (bytesConverted - 1) * 8 & 0xFF);
            lastConverterIndex[0] = group;
            if (group != 0 && ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGroup != group) {
                int n = pLMBCS;
                pLMBCS = (byte)(pLMBCS + 1);
                LMBCS[n] = (byte)group;
                if (bytesConverted == 1 && group >= 16) {
                    int n2 = pLMBCS;
                    pLMBCS = (byte)(pLMBCS + 1);
                    LMBCS[n2] = (byte)group;
                }
            }
            if (bytesConverted == 1 && firstByte < 32) {
                return 0;
            }
            switch (bytesConverted) {
                case 4: {
                    int n = pLMBCS;
                    pLMBCS = (byte)(pLMBCS + 1);
                    LMBCS[n] = (byte)(value[0] >> 24);
                }
                case 3: {
                    int n = pLMBCS;
                    pLMBCS = (byte)(pLMBCS + 1);
                    LMBCS[n] = (byte)(value[0] >> 16);
                }
                case 2: {
                    int n = pLMBCS;
                    pLMBCS = (byte)(pLMBCS + 1);
                    LMBCS[n] = (byte)(value[0] >> 8);
                }
                case 1: {
                    int n = pLMBCS;
                    pLMBCS = (byte)(pLMBCS + 1);
                    LMBCS[n] = (byte)value[0];
                }
            }
            return pLMBCS;
        }

        private int LMBCSConvertUni(byte[] LMBCS, char uniChar) {
            int index = 0;
            short LowCh = (short)(uniChar & 0xFF);
            short HighCh = (short)(uniChar >> 8 & 0xFF);
            LMBCS[index++] = 20;
            if (LowCh == 0) {
                LMBCS[index++] = (byte)ULMBCS_UNICOMPATZERO;
                LMBCS[index++] = (byte)HighCh;
            } else {
                LMBCS[index++] = (byte)HighCh;
                LMBCS[index++] = (byte)LowCh;
            }
            return 3;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult err = CoderResult.UNDERFLOW;
            short[] lastConverterIndex = new short[1];
            byte[] LMBCS = new byte[3];
            boolean[] groups_tried = new boolean[20];
            int sourceIndex = 0;
            short OldConverterIndex = 0;
            while (source.hasRemaining() && err.isUnderflow()) {
                OldConverterIndex = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex;
                if (!target.hasRemaining()) {
                    err = CoderResult.OVERFLOW;
                    break;
                }
                char uniChar = source.get(source.position());
                int bytes_written = 0;
                int pLMBCS = 0;
                if (uniChar >= '\u0080' && uniChar <= '\u00ff' && uniChar != '\u00b1' && uniChar != '\u00d7' && uniChar != '\u00f7' && uniChar != '\u00b0' && uniChar != '\u00b4' && uniChar != '\u00b6' && uniChar != '\u00a7' && uniChar != '\u00a8') {
                    ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex = 1;
                }
                if (uniChar > '\u001f' && uniChar < '\u0080' || uniChar == '\u0000' || uniChar == '\t' || uniChar == '\r' || uniChar == '\n' || uniChar == '\u0019') {
                    int n = pLMBCS;
                    pLMBCS = (byte)(pLMBCS + 1);
                    LMBCS[n] = (byte)uniChar;
                    bytes_written = 1;
                }
                if (bytes_written == 0) {
                    short group = CharsetLMBCS.FindLMBCSUniRange(uniChar);
                    if (group == 20) {
                        bytes_written = this.LMBCSConvertUni(LMBCS, uniChar);
                    } else if (group == 15) {
                        if (uniChar <= '\u001f') {
                            int n = pLMBCS;
                            pLMBCS = (byte)(pLMBCS + 1);
                            LMBCS[n] = 15;
                            int n2 = pLMBCS;
                            pLMBCS = (byte)(pLMBCS + 1);
                            LMBCS[n2] = (byte)(32 + uniChar);
                        } else if (uniChar >= '\u0080' && uniChar <= '\u00a0') {
                            int n = pLMBCS;
                            pLMBCS = (byte)(pLMBCS + 1);
                            LMBCS[n] = 15;
                            int n3 = pLMBCS;
                            pLMBCS = (byte)(pLMBCS + 1);
                            LMBCS[n3] = (byte)uniChar;
                        }
                        bytes_written = pLMBCS;
                    } else if (group < 20) {
                        bytes_written = this.LMBCSConversionWorker(group, LMBCS, uniChar, lastConverterIndex, groups_tried);
                    }
                    if (bytes_written == 0) {
                        groups_tried = new boolean[20];
                        if (((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGroup != 1 && CharsetLMBCS.this.ULMBCS_AMBIGUOUS_MATCH(group, ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGroup)) {
                            if (((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex < 16) {
                                bytes_written = this.LMBCSConversionWorker((short)1, LMBCS, uniChar, lastConverterIndex, groups_tried);
                                if (bytes_written == 0) {
                                    bytes_written = this.LMBCSConversionWorker((short)0, LMBCS, uniChar, lastConverterIndex, groups_tried);
                                }
                                if (bytes_written == 0) {
                                    bytes_written = this.LMBCSConversionWorker(((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex, LMBCS, uniChar, lastConverterIndex, groups_tried);
                                }
                            } else {
                                bytes_written = this.LMBCSConversionWorker(((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex, LMBCS, uniChar, lastConverterIndex, groups_tried);
                            }
                        }
                        if (bytes_written == 0 && ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex > 0 && CharsetLMBCS.this.ULMBCS_AMBIGUOUS_MATCH(group, ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex)) {
                            bytes_written = this.LMBCSConversionWorker(((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex, LMBCS, uniChar, lastConverterIndex, groups_tried);
                        }
                        if (bytes_written == 0 && lastConverterIndex[0] > 0 && CharsetLMBCS.this.ULMBCS_AMBIGUOUS_MATCH(group, lastConverterIndex[0])) {
                            bytes_written = this.LMBCSConversionWorker(lastConverterIndex[0], LMBCS, uniChar, lastConverterIndex, groups_tried);
                        }
                        if (bytes_written == 0) {
                            int grp_end;
                            short grp_start = group == 129 ? (short)16 : 1;
                            int n = grp_end = group == 129 ? 19 : 11;
                            if (group == 130) {
                                grp_start = 1;
                                grp_end = 19;
                            }
                            for (short grp_ix = grp_start; grp_ix <= grp_end && bytes_written == 0; grp_ix = (short)((short)(grp_ix + 1))) {
                                if (((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[grp_ix] == null || groups_tried[grp_ix]) continue;
                                bytes_written = this.LMBCSConversionWorker(grp_ix, LMBCS, uniChar, lastConverterIndex, groups_tried);
                            }
                            if (bytes_written == 0 && grp_start == 1) {
                                bytes_written = this.LMBCSConversionWorker((short)0, LMBCS, uniChar, lastConverterIndex, groups_tried);
                            }
                        }
                        if (bytes_written == 0) {
                            bytes_written = this.LMBCSConvertUni(LMBCS, uniChar);
                        }
                    }
                }
                source.get();
                pLMBCS = 0;
                while (target.hasRemaining() && bytes_written > 0) {
                    --bytes_written;
                    int n = pLMBCS;
                    pLMBCS = (byte)(pLMBCS + 1);
                    target.put(LMBCS[n]);
                    if (offsets == null) continue;
                    offsets.put(sourceIndex);
                }
                ++sourceIndex;
                if (bytes_written > 0) {
                    err = CoderResult.OVERFLOW;
                    this.errorBufferLength = bytes_written;
                    int i = 0;
                    while (bytes_written > 0) {
                        int n = pLMBCS;
                        pLMBCS = (byte)(pLMBCS + 1);
                        this.errorBuffer[i] = LMBCS[n];
                        ++i;
                        --bytes_written;
                    }
                }
                ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.localeConverterIndex = OldConverterIndex;
            }
            return err;
        }
    }

    class CharsetDecoderLMBCS
    extends CharsetDecoderICU {
        public CharsetDecoderLMBCS(CharsetICU cs) {
            super(cs);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
        }

        private char GetUniFromLMBCSUni(ByteBuffer ppLMBCSin) {
            short HighCh = (short)(ppLMBCSin.get() & 0xFF);
            short LowCh = (short)(ppLMBCSin.get() & 0xFF);
            if (HighCh == ULMBCS_UNICOMPATZERO) {
                HighCh = LowCh;
                LowCh = 0;
            }
            return (char)(HighCh << 8 | LowCh);
        }

        private int LMBCS_SimpleGetNextUChar(UConverterSharedData cnv, ByteBuffer source, int positionOffset, int length) {
            ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.charset.sharedData = cnv;
            int oldSourceLimit = source.limit();
            int oldSourcePos = source.position();
            source.position(oldSourcePos + positionOffset);
            source.limit(source.position() + length);
            int uniChar = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.decoder.simpleGetNextUChar(source, false);
            source.limit(oldSourceLimit);
            source.position(oldSourcePos);
            return uniChar;
        }

        private int LMBCSGetNextUCharWorker(ByteBuffer source, CoderResult[] err) {
            int uniChar = 0;
            if (!source.hasRemaining()) {
                err[0] = CoderResult.malformedForLength(0);
                return 65535;
            }
            int CurByte = source.get() & 0xFF;
            if (CurByte > 31 && CurByte < 128 || CurByte == 0 || CurByte == 9 || CurByte == 13 || CurByte == 10 || CurByte == 25) {
                uniChar = CurByte;
            } else if (CurByte == 15) {
                if (source.position() + 1 > source.limit()) {
                    err[0] = CoderResult.OVERFLOW;
                    source.position(source.limit());
                    return 65535;
                }
                int C0C1byte = source.get() & 0xFF;
                uniChar = C0C1byte < 128 ? C0C1byte - 32 : C0C1byte;
            } else {
                if (CurByte == 20) {
                    if (source.position() + 2 > source.limit()) {
                        err[0] = CoderResult.OVERFLOW;
                        source.position(source.limit());
                        return 65535;
                    }
                    return this.GetUniFromLMBCSUni(source);
                }
                if (CurByte <= 32) {
                    UConverterSharedData cnv;
                    int group = CurByte;
                    if (group > 19 || (cnv = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[group]) == null) {
                        err[0] = CoderResult.unmappableForLength(1);
                    } else if (group >= 16) {
                        if (source.position() + 2 > source.limit()) {
                            err[0] = CoderResult.OVERFLOW;
                            source.position(source.limit());
                            return 65535;
                        }
                        if (source.get(source.position()) == group) {
                            source.get();
                            uniChar = this.LMBCS_SimpleGetNextUChar(cnv, source, 0, 1);
                            source.get();
                        } else {
                            uniChar = this.LMBCS_SimpleGetNextUChar(cnv, source, 0, 2);
                            source.get();
                            source.get();
                        }
                    } else {
                        if (source.position() + 1 > source.limit()) {
                            err[0] = CoderResult.OVERFLOW;
                            source.position(source.limit());
                            return 65535;
                        }
                        CurByte = (short)(source.get() & 0xFF);
                        if (CurByte >= 128) {
                            uniChar = CharsetMBCS.MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(cnv.mbcs, CurByte);
                        } else {
                            byte[] bytes = new byte[2];
                            cnv = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[0];
                            bytes[0] = (byte)group;
                            bytes[1] = (byte)CurByte;
                            uniChar = this.LMBCS_SimpleGetNextUChar(cnv, ByteBuffer.wrap(bytes), 0, 2);
                        }
                    }
                } else if (CurByte >= 128) {
                    short group = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGroup;
                    UConverterSharedData cnv = ((CharsetLMBCS)CharsetLMBCS.this).extraInfo.OptGrpConverter[group];
                    if (group >= 16) {
                        if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(cnv.mbcs.stateTable[0][CurByte])) {
                            if (source.position() + 0 > source.limit()) {
                                err[0] = CoderResult.OVERFLOW;
                                source.position(source.limit());
                                return 65535;
                            }
                            uniChar = this.LMBCS_SimpleGetNextUChar(cnv, source, -1, 1);
                        } else {
                            if (source.position() + 1 > source.limit()) {
                                err[0] = CoderResult.OVERFLOW;
                                source.position(source.limit());
                                return 65535;
                            }
                            uniChar = this.LMBCS_SimpleGetNextUChar(cnv, source, -1, 2);
                            source.get();
                        }
                    } else {
                        uniChar = CharsetMBCS.MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(cnv.mbcs, CurByte);
                    }
                }
            }
            return uniChar;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult[] err = new CoderResult[]{CoderResult.UNDERFLOW};
            byte[] LMBCS = new byte[6];
            int errSource = 0;
            int savebytes = 0;
            while (err[0].isUnderflow() && source.hasRemaining() && target.hasRemaining()) {
                char uniChar;
                int saveSource = source.position();
                if (this.toULength > 0) {
                    int i;
                    int size_old = this.toULength;
                    int size_new_maybe_1 = 3 - size_old;
                    int size_new_maybe_2 = source.remaining();
                    int size_new = size_new_maybe_1 < size_new_maybe_2 ? size_new_maybe_1 : size_new_maybe_2;
                    savebytes = (byte)(size_old + size_new);
                    for (i = 0; i < savebytes; ++i) {
                        LMBCS[i] = i < size_old ? this.toUBytesArray[i] : source.get();
                    }
                    ByteBuffer tmpSourceBuffer = ByteBuffer.wrap(LMBCS);
                    tmpSourceBuffer.limit(savebytes);
                    uniChar = (char)this.LMBCSGetNextUCharWorker(tmpSourceBuffer, err);
                    source.position(saveSource + tmpSourceBuffer.position() - size_old);
                    errSource = saveSource - size_old;
                    if (err[0].isOverflow()) {
                        this.toULength = savebytes;
                        for (i = 0; i < savebytes; ++i) {
                            this.toUBytesArray[i] = LMBCS[i];
                        }
                        source.position(source.limit());
                        err[0] = CoderResult.UNDERFLOW;
                        return err[0];
                    }
                    this.toULength = 0;
                } else {
                    errSource = saveSource;
                    uniChar = (char)this.LMBCSGetNextUCharWorker(source, err);
                    savebytes = (byte)(source.position() - saveSource);
                }
                if (!err[0].isUnderflow()) continue;
                if (uniChar < '\ufffe') {
                    target.put(uniChar);
                    if (offsets == null) continue;
                    offsets.put(saveSource);
                    continue;
                }
                if (uniChar == '\ufffe') {
                    err[0] = CoderResult.unmappableForLength(source.position() - saveSource);
                    continue;
                }
                err[0] = CoderResult.malformedForLength(source.position() - saveSource);
            }
            if (err[0].isUnderflow() && source.hasRemaining() && !target.hasRemaining()) {
                err[0] = CoderResult.OVERFLOW;
            } else if (!err[0].isUnderflow()) {
                this.toULength = savebytes;
                if (savebytes > 0) {
                    for (int i = 0; i < savebytes; ++i) {
                        this.toUBytesArray[i] = source.get(errSource + i);
                    }
                }
                if (err[0].isOverflow()) {
                    err[0] = CoderResult.UNDERFLOW;
                }
            }
            return err[0];
        }
    }

    private static class UConverterDataLMBCS {
        UConverterSharedData[] OptGrpConverter = new UConverterSharedData[20];
        short OptGroup;
        short localeConverterIndex;
        CharsetMBCS.CharsetDecoderMBCS decoder;
        CharsetMBCS.CharsetEncoderMBCS encoder;
        CharsetMBCS charset = (CharsetMBCS)CharsetICU.forNameICU("ibm-850");

        UConverterDataLMBCS() {
            this.encoder = (CharsetMBCS.CharsetEncoderMBCS)this.charset.newEncoder();
            this.decoder = (CharsetMBCS.CharsetDecoderMBCS)this.charset.newDecoder();
        }
    }

    private static class _LocaleLMBCSGrpMap {
        String LocaleID;
        short OptGroup;

        _LocaleLMBCSGrpMap(String LocaleID, short OptGroup) {
            this.LocaleID = LocaleID;
            this.OptGroup = OptGroup;
        }
    }

    private static class _UniLMBCSGrpMap {
        int uniStartRange;
        int uniEndRange;
        short GrpType;

        _UniLMBCSGrpMap(int uniStartRange, int uniEndRange, short GrpType) {
            this.uniStartRange = uniStartRange;
            this.uniEndRange = uniEndRange;
            this.GrpType = GrpType;
        }
    }
}

