/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import net.jsign.PESigner;
import net.jsign.PVK;
import net.jsign.pe.PEFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class PESignerTask
extends Task {
    private File file;
    private String name;
    private String url;
    private File keystore;
    private String storepass;
    private String storetype = "JKS";
    private String alias;
    private File certfile;
    private File keyfile;
    private String keypass;
    private String tsaurl;

    public void setFile(File file) {
        this.file = file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setKeystore(File keystore) {
        this.keystore = keystore;
        String name = keystore.getName().toLowerCase();
        if (name.endsWith(".p12") || name.endsWith(".pfx")) {
            this.storetype = "PKCS12";
        }
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setCertfile(File certfile) {
        this.certfile = certfile;
    }

    public void setKeyfile(File keyfile) {
        this.keyfile = keyfile;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setTsaurl(String tsaurl) {
        this.tsaurl = tsaurl;
    }

    public void execute() throws BuildException {
        PEFile peFile;
        PrivateKey privateKey;
        Certificate[] chain;
        if (this.keystore == null && this.keyfile == null && this.certfile == null) {
            throw new BuildException("keystore attribute, or keyfile and certfile attributes must be set");
        }
        if (this.keystore != null && (this.keyfile != null || this.certfile != null)) {
            throw new BuildException("keystore attribute can't be mixed with keyfile or certfile");
        }
        if (this.keystore != null) {
            KeyStore ks;
            try {
                ks = KeyStore.getInstance(this.storetype);
            }
            catch (KeyStoreException e) {
                throw new BuildException("keystore type '" + this.storetype + "' is not supported", (Throwable)e);
            }
            if (!this.keystore.exists()) {
                throw new BuildException("The keystore " + this.keystore + " couldn't be found");
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.keystore);
                ks.load(in, this.storepass != null ? this.storepass.toCharArray() : null);
            }
            catch (Exception e) {
                throw new BuildException("Unable to load the keystore " + this.keystore, (Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {}
            }
            if (this.alias == null) {
                throw new BuildException("alias attribute must be set");
            }
            try {
                chain = ks.getCertificateChain(this.alias);
            }
            catch (KeyStoreException e) {
                throw new BuildException((Throwable)e);
            }
            if (chain == null) {
                throw new BuildException("No certificate found under the alias '" + this.alias + "' in the keystore " + this.keystore);
            }
            char[] password = this.keypass != null ? this.keypass.toCharArray() : this.storepass.toCharArray();
            try {
                privateKey = (PrivateKey)ks.getKey(this.alias, password);
            }
            catch (Exception e) {
                throw new BuildException("Failed to retrieve the private key from the keystore", (Throwable)e);
            }
        }
        if (this.keyfile == null) {
            throw new BuildException("keyfile attribute must be set");
        }
        if (!this.keyfile.exists()) {
            throw new BuildException("The keyfile " + this.keyfile + " couldn't be found");
        }
        if (this.certfile == null) {
            throw new BuildException("certfile attribute must be set");
        }
        if (!this.certfile.exists()) {
            throw new BuildException("The certfile " + this.certfile + " couldn't be found");
        }
        try {
            chain = this.loadCertificateChain(this.certfile);
        }
        catch (Exception e) {
            throw new BuildException("Failed to load the certificate from " + this.certfile, (Throwable)e);
        }
        try {
            privateKey = PVK.parse(this.keyfile, this.keypass);
        }
        catch (Exception e) {
            throw new BuildException("Failed to load the private key from " + this.keyfile, (Throwable)e);
        }
        if (this.file == null) {
            throw new BuildException("file attribute must be set");
        }
        if (!this.file.exists()) {
            throw new BuildException("The file " + this.file + " couldn't be found");
        }
        try {
            peFile = new PEFile(this.file);
        }
        catch (IOException e) {
            throw new BuildException("Couldn't open the executable file " + this.file, (Throwable)e);
        }
        PESigner signer = new PESigner(chain, privateKey).withProgramName(this.name).withProgramURL(this.url).withTimestamping(this.tsaurl != null).withTimestampingAutority(this.tsaurl);
        try {
            this.log("Adding Authenticode signature to " + FileUtils.getRelativePath((File)this.getProject().getBaseDir(), (File)this.file));
            signer.sign(peFile);
        }
        catch (Exception e) {
            throw new BuildException("Couldn't sign " + this.file, (Throwable)e);
        }
        finally {
            try {
                peFile.close();
            }
            catch (IOException e) {
                this.log("Couldn't close " + this.file, e, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate[] loadCertificateChain(File file) throws IOException, CertificateException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(in);
            Certificate[] certificateArray = certificates.toArray(new Certificate[certificates.size()]);
            return certificateArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

