/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.AuthenticodeSignedDataGenerator;
import net.jsign.asn1.authenticode.AuthenticodeTimeStampRequest;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcSpOpusInfo;
import net.jsign.asn1.authenticode.SpcStatementType;
import net.jsign.pe.DataDirectoryType;
import net.jsign.pe.PEFile;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.encoders.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PESigner {
    private Certificate[] chain;
    private PrivateKey privateKey;
    private String programName;
    private String programURL;
    private boolean timestamping = true;
    private String tsaurl = "http://timestamp.comodoca.com/authenticode";

    public PESigner(Certificate[] chain, PrivateKey privateKey) {
        this.chain = chain;
        this.privateKey = privateKey;
    }

    public PESigner(KeyStore keystore, String alias, String password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        this(keystore.getCertificateChain(alias), (PrivateKey)keystore.getKey(alias, password.toCharArray()));
    }

    public PESigner withProgramName(String programName) {
        this.programName = programName;
        return this;
    }

    public PESigner withProgramURL(String programURL) {
        this.programURL = programURL;
        return this;
    }

    public PESigner withTimestamping(boolean timestamping) {
        this.timestamping = timestamping;
        return this;
    }

    public PESigner withTimestampingAutority(String url) {
        this.tsaurl = url;
        return this;
    }

    public void sign(PEFile file) throws Exception {
        file.pad(8);
        byte[] certificateTable = this.createCertificateTable(file);
        file.writeDataDirectory(DataDirectoryType.CERTIFICATE_TABLE, certificateTable);
        file.close();
    }

    private byte[] createCertificateTable(PEFile file) throws IOException, CMSException, OperatorCreationException, CertificateEncodingException {
        CMSSignedData sigData = this.createSignature(file);
        if (this.timestamping) {
            sigData = this.timestamp(sigData);
        }
        byte[] signature = sigData.toASN1Structure().getEncoded("DER");
        signature = this.pad(signature, 8);
        ByteBuffer buffer = ByteBuffer.allocate(signature.length + 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(buffer.limit());
        buffer.putShort((short)512);
        buffer.putShort((short)2);
        buffer.put(signature);
        return buffer.array();
    }

    private byte[] pad(byte[] data, int multiple) {
        if (data.length % multiple == 0) {
            return data;
        }
        byte[] copy = new byte[data.length + (multiple - data.length % multiple)];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    private CMSSignedData createSignature(PEFile file) throws IOException, CMSException, OperatorCreationException, CertificateEncodingException {
        byte[] sha1 = file.computeDigest("SHA1");
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, (ASN1Encodable)DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, sha1);
        SpcIndirectDataContent spcIndirectDataContent = new SpcIndirectDataContent(digestInfo);
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1with" + this.privateKey.getAlgorithm()).build(this.privateKey);
        DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().build();
        DefaultAuthenticatedAttributeTableGenerator attributeTableGenerator = new DefaultAuthenticatedAttributeTableGenerator(this.createAuthenticatedAttributes());
        JcaX509CertificateHolder certificate = new JcaX509CertificateHolder((X509Certificate)this.chain[0]);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new SignerInfoGeneratorBuilder(digestCalculatorProvider);
        signerInfoGeneratorBuilder.setSignedAttributeGenerator(attributeTableGenerator);
        SignerInfoGenerator signerInfoGenerator = signerInfoGeneratorBuilder.build(sha1Signer, certificate);
        AuthenticodeSignedDataGenerator generator = new AuthenticodeSignedDataGenerator();
        generator.addCertificates(new JcaCertStore(this.removeRoot(this.chain)));
        generator.addSignerInfoGenerator(signerInfoGenerator);
        return generator.generate(AuthenticodeObjectIdentifiers.SPC_INDIRECT_DATA_OBJID, spcIndirectDataContent);
    }

    private List<Certificate> removeRoot(Certificate[] certificates) {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        if (certificates.length == 1) {
            list.add(certificates[0]);
        } else {
            for (Certificate certificate : certificates) {
                if (this.isSelfSigned((X509Certificate)certificate)) continue;
                list.add(certificate);
            }
        }
        return list;
    }

    private boolean isSelfSigned(X509Certificate certificate) {
        return ((Object)certificate.getSubjectDN()).equals(certificate.getIssuerDN());
    }

    private AttributeTable createAuthenticatedAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        SpcStatementType spcStatementType = new SpcStatementType(AuthenticodeObjectIdentifiers.SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID);
        attributes.add(new Attribute(AuthenticodeObjectIdentifiers.SPC_STATEMENT_TYPE_OBJID, (ASN1Set)new DERSet(spcStatementType)));
        if (this.programName != null || this.programURL != null) {
            SpcSpOpusInfo spcSpOpusInfo = new SpcSpOpusInfo(this.programName, this.programURL);
            attributes.add(new Attribute(AuthenticodeObjectIdentifiers.SPC_SP_OPUS_INFO_OBJID, (ASN1Set)new DERSet(spcSpOpusInfo)));
        }
        return new AttributeTable(new DERSet(attributes.toArray(new ASN1Encodable[attributes.size()])));
    }

    private CMSSignedData timestamp(CMSSignedData sigData) throws IOException, CMSException {
        SignerInformation signerInformation = (SignerInformation)sigData.getSignerInfos().getSigners().iterator().next();
        CMSSignedData token = this.timestamp(signerInformation.toASN1Structure().getEncryptedDigest().getOctets(), new URL(this.tsaurl));
        SignerInformation timestampSignerInformation = (SignerInformation)token.getSignerInfos().getSigners().iterator().next();
        Attribute counterSignature = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(timestampSignerInformation.toASN1Structure()));
        signerInformation = SignerInformation.replaceUnsignedAttributes(signerInformation, new AttributeTable(new DERSet(counterSignature)));
        ArrayList certificates = new ArrayList();
        certificates.addAll(sigData.getCertificates().getMatches(null));
        certificates.addAll(token.getCertificates().getMatches(null));
        CollectionStore certificateStore = new CollectionStore(certificates);
        AuthenticodeSignedDataGenerator generator = new AuthenticodeSignedDataGenerator();
        generator.addCertificates(certificateStore);
        generator.addSigners(new SignerInformationStore(Arrays.asList(signerInformation)));
        ASN1ObjectIdentifier contentType = new ASN1ObjectIdentifier(sigData.getSignedContentTypeOID());
        ASN1Sequence content = ASN1Sequence.getInstance(sigData.getSignedContent().getContent());
        return generator.generate(contentType, content);
    }

    private CMSSignedData timestamp(byte[] encryptedDigest, URL tsaurl) throws IOException, CMSException {
        int n;
        AuthenticodeTimeStampRequest timestampRequest = new AuthenticodeTimeStampRequest(encryptedDigest);
        byte[] request = Base64.encode(timestampRequest.getEncoded("DER"));
        HttpURLConnection conn = (HttpURLConnection)tsaurl.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-type", "application/octet-stream");
        conn.setRequestProperty("Content-length", String.valueOf(request.length));
        conn.setRequestProperty("Accept", "application/octet-stream");
        conn.setRequestProperty("User-Agent", "Transport");
        conn.getOutputStream().write(request);
        conn.getOutputStream().flush();
        if (conn.getResponseCode() >= 400) {
            throw new IOException("Unable to complete the timestamping due to HTTP error: " + conn.getResponseCode() + " - " + conn.getResponseMessage());
        }
        InputStream in = conn.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((n = in.read(buffer)) != -1) {
            bout.write(buffer, 0, n);
        }
        byte[] response = Base64.decode(bout.toByteArray());
        return new CMSSignedData(response);
    }
}

